/*! FileSaver.js
 *  A saveAs() FileSaver implementation.
 *  2014-01-24
 *
 *  By Eli Grey, http://eligrey.com
 *  License: X11/MIT
 *    See LICENSE.md
 */
/*! @source http://purl.eligrey.com/github/FileSaver.js/blob/master/FileSaver.js */
var saveAs=saveAs||"undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob&&navigator.msSaveOrOpenBlob.bind(navigator)||function(view){"use strict";if("undefined"==typeof navigator||!/MSIE [1-9]\./.test(navigator.userAgent)){var doc=view.document,get_URL=function(){return view.URL||view.webkitURL||view},URL=view.URL||view.webkitURL||view,save_link=doc.createElementNS("http://www.w3.org/1999/xhtml","a"),can_use_save_link=!view.externalHost&&"download"in save_link,click=function(node){var event=doc.createEvent("MouseEvents");event.initMouseEvent("click",!0,!1,view,0,0,0,0,0,!1,!1,!1,!1,0,null),node.dispatchEvent(event)},webkit_req_fs=view.webkitRequestFileSystem,req_fs=view.requestFileSystem||webkit_req_fs||view.mozRequestFileSystem,throw_outside=function(ex){(view.setImmediate||view.setTimeout)((function(){throw ex}),0)},force_saveable_type="application/octet-stream",fs_min_size=0,deletion_queue=[],process_deletion_queue=function(){for(var i=deletion_queue.length;i--;){var file=deletion_queue[i];"string"==typeof file?URL.revokeObjectURL(file):file.remove()}deletion_queue.length=0},dispatch=function(filesaver,event_types,event){for(var i=(event_types=[].concat(event_types)).length;i--;){var listener=filesaver["on"+event_types[i]];if("function"==typeof listener)try{listener.call(filesaver,event||filesaver)}catch(ex){throw_outside(ex)}}},FileSaver=function(blob,name){var filesaver=this,type=blob.type,blob_changed=!1,object_url,target_view,get_object_url=function(){var object_url=get_URL().createObjectURL(blob);return deletion_queue.push(object_url),object_url},dispatch_all=function(){dispatch(filesaver,"writestart progress write writeend".split(" "))},fs_error=function(){!blob_changed&&object_url||(object_url=get_object_url(blob)),target_view?target_view.location.href=object_url:window.open(object_url,"_blank"),filesaver.readyState=filesaver.DONE,dispatch_all()},abortable=function(func){return function(){if(filesaver.readyState!==filesaver.DONE)return func.apply(this,arguments)}},create_if_not_found={create:!0,exclusive:!1},slice;if(filesaver.readyState=filesaver.INIT,name||(name="download"),can_use_save_link){object_url=get_object_url(blob),doc=view.document,(save_link=doc.createElementNS("http://www.w3.org/1999/xhtml","a")).href=object_url,save_link.download=name;var event=doc.createEvent("MouseEvents");return event.initMouseEvent("click",!0,!1,view,0,0,0,0,0,!1,!1,!1,!1,0,null),save_link.dispatchEvent(event),filesaver.readyState=filesaver.DONE,void dispatch_all()}view.chrome&&type&&type!==force_saveable_type&&(slice=blob.slice||blob.webkitSlice,blob=slice.call(blob,0,blob.size,force_saveable_type),blob_changed=!0),webkit_req_fs&&"download"!==name&&(name+=".download"),(type===force_saveable_type||webkit_req_fs)&&(target_view=view),req_fs?(fs_min_size+=blob.size,req_fs(view.TEMPORARY,fs_min_size,abortable((function(fs){fs.root.getDirectory("saved",create_if_not_found,abortable((function(dir){var save=function(){dir.getFile(name,create_if_not_found,abortable((function(file){file.createWriter(abortable((function(writer){writer.onwriteend=function(event){target_view.location.href=file.toURL(),deletion_queue.push(file),filesaver.readyState=filesaver.DONE,dispatch(filesaver,"writeend",event)},writer.onerror=function(){var error=writer.error;error.code!==error.ABORT_ERR&&fs_error()},"writestart progress write abort".split(" ").forEach((function(event){writer["on"+event]=filesaver["on"+event]})),writer.write(blob),filesaver.abort=function(){writer.abort(),filesaver.readyState=filesaver.DONE},filesaver.readyState=filesaver.WRITING})),fs_error)})),fs_error)};dir.getFile(name,{create:!1},abortable((function(file){file.remove(),save()})),abortable((function(ex){ex.code===ex.NOT_FOUND_ERR?save():fs_error()})))})),fs_error)})),fs_error)):fs_error()},FS_proto=FileSaver.prototype,saveAs=function(blob,name){return new FileSaver(blob,name)};return FS_proto.abort=function(){var filesaver=this;this.readyState=this.DONE,dispatch(this,"abort")},FS_proto.readyState=FS_proto.INIT=0,FS_proto.WRITING=1,FS_proto.DONE=2,FS_proto.error=FS_proto.onwritestart=FS_proto.onprogress=FS_proto.onwrite=FS_proto.onabort=FS_proto.onerror=FS_proto.onwriteend=null,view.addEventListener("unload",process_deletion_queue,!1),saveAs.unload=function(){process_deletion_queue(),view.removeEventListener("unload",process_deletion_queue,!1)},saveAs}}("undefined"!=typeof self&&self||"undefined"!=typeof window&&window||this.content);"undefined"!=typeof module&&null!==module?module.exports=saveAs:"undefined"!=typeof define&&null!==define&&null!=define.amd&&define([],(function(){return saveAs}));